/*****************************************************************
	Basics.h

	Created 2005 by Edward A. Richley (richley@mailaps.org)

	This file is subject to the terms and conditions of the 
	GNU General Public License. 

        Change log:
        8/29/2019 Fixed definitions of SQR(x) and CUBE(x)         EAR

*****************************************************************/
#ifndef Basics
#define Basics

#define pi 3.14159265
#define PI 3.14159265
#define EPS_MACH 2.22045e-16
#define MIN_DOUBLE 2.22507385850720138309023271733240406422e-308
#define MAX_DOUBLE 8.98846567431157953864652595394512366809e+307
#define  nil 0
#define true 1
#define false 0
#define TRUE 1
#define FALSE 0
#define N0 6.022e23                /* Avogadro's number */
#define k 1.38e-23                 /* Boltzmann's constant (J/K) */
#define h_const 6.625e-34          /* Planck's constant (J-s) */
#define eps0 8.85e-12              /* permittivity of free space */
#define q0 1.6021917e-19           /* fundamental charge (C) */
#define amu 1.660e-27              /* atomic mass unit (kg) */
#define m_proton 1.672e-27         /* proton mass (kg) */
#define m_elec 9.109e-31           /* electron mass (kg) */
#define EOM 1.75891e11             /* (q0/m_elec) */
#define EOK 11610.085              /* (q0/k) */
#define MOE 5.68533e-12            /* (m_elec/q0) */
#define TEOM 3.51782e11            /* (2.0*q0/m_elec) */
#define EOTM 8.79455e10            /* (q0/(2.0*m_elec)) */
#define SEOTM 2.96556e5            /* sqrt(eotm) */
#define STEOM 5.9311224e5          /* sqrt(teom) */
#define SMOTE 1.68634e-6           /* sqrt(moe/2) */
#define FOURPI 12.566371           /* 4 pi */
#define FOURPIEOM 2.21031e12       /* 4 pi q0/m_elec */
#define TORR_TO_BAR 1.31578947e2   /* converts Torr to Bar */
#define VM2_to_Td 1.0e21           /* Converts V-M+2 to Townsend */
#define Std_Temp 300.0
#define ZERO_C 273.0               /* 0 degrees C in K */
#define sqrt_3 1.7320508075688772935274463
#define sqrt_2 1.41421356237309504880168872420
#define SQRT_PI 1.77245385090551602729816748
#define PI_2 1.57079632679489661923132169163
#define SQRT__PI_2 1.25331413731550025120788264240
#define FIVE_ONENINETYTWO .0260416666666666667
#define FIVE_TWELFTHS .4166666666666666666667
#define THREE_THIRTYTWO .09375
#define ONE_SIXTH .16666666666666667
#define ONE_THIRD .33333333333333333
#define THREE_SIXTEENTHS .1875
#define THREE_EIGHTHS .375
#define TWO_THIRDS .6666666666666667

#define max(a, b) ((a>b)?a:b)
#define min(a, b) ((a>b)?b:a)
#define ABS(x) max((x),-(x))
#define SQR(x) ((x)*(x))
#define CUBE(x) ((x)*(x)*(x))
#define get_memory(a,b,c) (c *)((a == NULL)?malloc((b)*sizeof(c)):(free(a),malloc((b)*sizeof(c))))
#define SWAP_VAL(type, x, y) {type temp = (x); (x) = (y), (y) = temp;} 

typedef int bool;
typedef char *string;
typedef string *stringptr;
typedef unsigned nat;
typedef double *dblptr;
typedef unsigned int *unsigned_int_ptr;
typedef void (*void_fn)();
typedef void_fn *void_fn_ptr;
typedef double (*double_fn)();
typedef double_fn *double_fn_ptr; 
typedef bool (*bool_fn)();
typedef bool_fn *bool_fn_ptr;
struct evect {double h; double e;};
struct xvect {double xf; double xr;};

#endif
