/************************************************************

	pbd_test.c

	Created 2005 by Edward A. Richley (richley@mailaps.org)

	This file is subject to the terms and conditions of the 
	GNU General Public License. 

************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "basics.h"
#include "pbd.h"
/************************************************************

	eqns(double *x)
		
	Returns pointer to vector of function evaluations
	for pbd integration routine. 
		
	NOTE: Time derivative (dx[i]/dt) must be represented as:
		
		(beta*x[i]+xdot[i])

	or, using the equivalent macro:

		dx_dt(i)


	which expands to the same thing.
			
	Then, eqns can be thought of as a set of equations of the form:
		
		result[i] = fi(x, dx/dt, pbd_Time) 
		
	with the solution being found when fi(x, dx/dt, pbd_Time) = 0.

	pbd_Time is the independent variable.

	Example given here is for dx[0]/dt = - x[1]; dx[1]/dt = x[0],
	with a solution of  x[0] = -sin(t); x[1] = cos(t) for initial
	conditions x[0] = 0, x[1] = 1.
		
************************************************************/
double *eqns(x)
dblptr x;
{
	unsigned int i;
	static bool First_Time = true;
	static dblptr result = NULL;
	
	if (First_Time) {
		result = get_memory(result,(N_eq),double);
		if (result == NULL) {printf("no memory [eqns]\n");}
		First_Time = false;
	}
	//	result[0] = (beta*x[0]+xdot[0]) + x[1];
	//	result[1] = (beta*x[1]+xdot[1]) - x[0];
	result[0] = dx_dt(0) + x[1];
	result[1] = dx_dt(1) - x[0];
	return(result);
}

/************************************************************

	main()

	prompts for time interval and initial values

************************************************************/
main(){
	unsigned int N = 2, i;
	static double x[2];
	double deltaT, dt;
	
	pbd_outfile = fopen("sin.dat","w");

	fprintf(stderr,"delta t: ");
	scanf("%lf", &deltaT);

	fprintf(stderr,"initial x:");
	scanf("%lf",&x[0]);
	fprintf(stderr,"initial y:");
	scanf("%lf",&x[1]);

	pbd_tol = .00001; pbd_N_tries = 50;
	if (pbd(2,x,deltaT,eqns, true)){
	  fprintf(stderr,"x: %8.5e y: %8.5e\n",x[0],x[1]);
	} else {
	  fprintf(stderr,"Failure in pbd\n");
	}
	fclose(pbd_outfile);
	return(0);
}


